#include "Tx64TransmitOptions.h"

Tx64TransmitOptions::Tx64TransmitOptions() { }

Tx64TransmitOptions::Tx64TransmitOptions(unsigned char value)
    : OptionsBase(value)
{ }

Tx64TransmitOptions::Tx64TransmitOptions(bool disable_retries_and_route_repair, bool donot_repeat_packet, bool send_packet_with_broadcast_PanID, bool invoke_traceroute, bool purge_packet_if_delayed_due_to_duty_cycle)
{
    value = 0x00;
    if (disable_retries_and_route_repair)
        value |= 0x01;
    if (donot_repeat_packet)
        value |= 0x02;
    if (send_packet_with_broadcast_PanID)
        value |= 0x04;
    if (invoke_traceroute)
        value |= 0x08;
    if (purge_packet_if_delayed_due_to_duty_cycle)
        value |= 0x10;
}

Tx64TransmitOptions * Tx64TransmitOptions::DonotRepeatPacket = new Tx64TransmitOptions(0x02);

Tx64TransmitOptions * Tx64TransmitOptions::SendPacketWithBroadcastPanID = new Tx64TransmitOptions(0x04);

Tx64TransmitOptions * Tx64TransmitOptions::InvokeTraceroute = new Tx64TransmitOptions(0x08);

Tx64TransmitOptions * Tx64TransmitOptions::PurgePacketWhenDelayed = new Tx64TransmitOptions(0x10);

bool Tx64TransmitOptions::getDonotRepeatPacket()
{
    if ((value & 0x02) == 0x02)
        return true;
    else return false;
}

void Tx64TransmitOptions::setDonotRepeatPacket(bool status)
{
    if (status)
        value |= 0x02;
    else
        value &= 0xFD;
}

bool Tx64TransmitOptions::getSendPacketWithBroadcastPanID()
{
    if ((value & 0x04) == 0x04)
        return true;
    else return false;
}

void Tx64TransmitOptions::setSendPacketWithBroadcastPanID(bool status)
{
    if (status)
        value |= 0x04;
    else
        value &= 0xFB;
}

bool Tx64TransmitOptions::getInvokeTraceroute()
{
    if ((value & 0x08) == 0x08)
        return true;
    else return false;
}

void Tx64TransmitOptions::setInvokeTraceroute(bool status)
{
    if (status)
        value |= 0x08;
    else
        value &= 0xF7;
}

bool Tx64TransmitOptions::getPurgePacketWhenDelayed()
{
    if ((value & 0x10) == 0x10)
        return true;
    else return false;
}

void Tx64TransmitOptions::setPurgePacketWhenDelayed(bool status)
{
    if (status)
        value |= 0x10;
    else
        value &= 0xEF;
}
