#ifndef UK_AC_HERTS_SMARTLAB_XBEE_ZigBeeRxIndicator
#define UK_AC_HERTS_SMARTLAB_XBEE_ZigBeeRxIndicator

#include "RxBase.h"
#include "Address.h"
#include "IPayloadResponse.h"

class ZigBeeRxIndicator: public IPayloadResponse, public RxBase
{
public:
    ZigBeeRxIndicator(APIFrame * frame);

    virtual unsigned  char * getReceivedData();

    virtual int getReceivedDataOffset();

    virtual char getReceivedData(int index);

    virtual int getReceivedDataLength();

    /**
    * bit mask
    * SUCCESS = 0x00,
    * PACKET_ACKNOWLEDGED = 0x01,
    * PACKET_WAS_A_BROADCAST = 0x02,
    * PACKET_RECEIVED_ON_BOARDCAST_PAN = 0x04,
    * PACKET_ENCRYPTED_WITH_APS_ENCRYPTION = 0x20,
    * PACKET_WAS_SENT_FROM_AN_END_DEVICE = 0x40,
    */
    virtual int getReceiveStatus();

    virtual Address getRemoteDevice();

    virtual int getRSSI();
    
    bool convert(APIFrame * frame);
};

#endif