#include "ZigBeeRxIndicator.h"

ZigBeeRxIndicator::ZigBeeRxIndicator(APIFrame * frame)
    : RxBase(frame)
{ }

unsigned  char * ZigBeeRxIndicator::getReceivedData()
{
    if (getReceivedDataLength() <= 0)
        return NULL;

    return data + 12;
}

int  ZigBeeRxIndicator::getReceivedDataOffset()
{
    return 12;
}

char  ZigBeeRxIndicator::getReceivedData(int index)
{
    return data[12 + index];
}

int  ZigBeeRxIndicator::getReceivedDataLength()
{
    return getPosition() - 12;
}

int  ZigBeeRxIndicator::getReceiveStatus()
{
    return data[11];
}

Address  ZigBeeRxIndicator::getRemoteDevice()
{
    return Address(data + 1);
}

int  ZigBeeRxIndicator::getRSSI()
{
    return 0;
}

bool  ZigBeeRxIndicator::convert(APIFrame * frame)
{
    if (frame == NULL)
        return false;

    if (frame->getFrameType() != APIFrame::ZigBee_Receive_Packet)
        return false;

    return APIFrame::convert(frame);
}