#include "XBeeRx64Indicator.h"

XBeeRx64Indicator::XBeeRx64Indicator(APIFrame * frame)
    : RxBase(frame)
{ }

unsigned  char * XBeeRx64Indicator::getReceivedData()
{
    if (getReceivedDataLength() <= 0)
        return NULL;

    return data + 11;
}

int XBeeRx64Indicator::getReceivedDataOffset()
{
    return 11;
}

char XBeeRx64Indicator::getReceivedData(int index)
{
    return data[11 + index];
}

int XBeeRx64Indicator::getReceivedDataLength()
{
    return getPosition() - 11;
}

int XBeeRx64Indicator::getRSSI()
{
    return data[9] * -1;
}

int XBeeRx64Indicator::getReceiveStatus()
{
    return data[10];
}

Address XBeeRx64Indicator::getRemoteDevice()
{
    return Address(data + 1, NULL);
}

bool XBeeRx64Indicator::convert(APIFrame * frame)
{
    if (frame == NULL)
        return false;

    if (frame->getFrameType() != APIFrame::Rx64_Receive_Packet)
        return false;

    return APIFrame::convert(frame);
}

