#ifndef UK_AC_HERTS_SMARTLAB_XBEE_SensorReadIndicator
#define UK_AC_HERTS_SMARTLAB_XBEE_SensorReadIndicator

#include "RxBase.h"
#include "Address.h"

class SensorReadIndicator:  public RxBase
{
public:
    SensorReadIndicator(APIFrame * frame);

    Address GetRemoteDevice();

    /**
    * bit mask
    * SUCCESS = 0x00,
    * PACKET_ACKNOWLEDGED = 0x01,
    * PACKET_WAS_A_BROADCAST = 0x02,
    * PACKET_RECEIVED_ON_BOARDCAST_PAN = 0x04,
    * PACKET_ENCRYPTED_WITH_APS_ENCRYPTION = 0x20,
    * PACKET_WAS_SENT_FROM_AN_END_DEVICE = 0x40,
    */
    int GetReceiveStatus();

    /**
    *    AD_SENSOR_READ = 0x01,
    *    TEMPERATURE_SENSOR_READ = 0x02,
    *    HUMIDITY_SENSOR_READ = 0x03,
    *    WATER_PRESENT = 0x60,
    */
    int GetOneWireSensor();

    int GetAD0();

    int GetAD1();

    int GetAD2();

    int GetAD3();

    int GetThemometer();
    
    bool convert(APIFrame * frame);
};

#endif