#include "SensorReadIndicator.h"

SensorReadIndicator::SensorReadIndicator(APIFrame * frame)
    : RxBase(frame)
{ }

Address SensorReadIndicator::GetRemoteDevice()
{
    return Address(data + 1);
}

int SensorReadIndicator::GetReceiveStatus()
{
    return data[11];
}

int SensorReadIndicator::GetOneWireSensor()
{
    return data[12];
}

int SensorReadIndicator::GetAD0()
{
    return (data[13] << 8) | data[14];
}

int SensorReadIndicator::GetAD1()
{
    return (data[15] << 8) | data[16];
}

int SensorReadIndicator::GetAD2()
{
    return (data[17] << 8) | data[18];
}

int SensorReadIndicator::GetAD3()
{
    return (data[19] << 8) | data[20];
}

int SensorReadIndicator::GetThemometer()
{
    return (data[21] << 8) | data[22];
}

bool  SensorReadIndicator::convert(APIFrame * frame)
{
    if (frame == NULL)
        return false;

    if (frame->getFrameType() != APIFrame::XBee_Sensor_Read_Indicato)
        return false;

    return APIFrame::convert(frame);
}