#ifndef UK_AC_HERTS_SMARTLAB_XBEE_RemoteCommandIndicator
#define UK_AC_HERTS_SMARTLAB_XBEE_RemoteCommandIndicator

#include "Address.h"
#include "RxBase.h"
#include "ICommandResponse.h"

class RemoteCommandIndicator : public ICommandResponse, public RxBase
{
public:

    RemoteCommandIndicator(APIFrame * frame);

    virtual int getFrameID();
    
    virtual unsigned  char * getRequestCommand();

    /**
    *
    * @returns
    *    OK = 0x00,
    *    ERROR = 0x01,
    *    INVALID_COMMAND = 0x02,
    *    INVALID_Parameter = 0x03,
    *    TRANSMISSION_FAILED = 0x04,
    */
    virtual int getCommandStatus();

    Address getRemoteDevice();

    virtual unsigned  char * getParameter();

    virtual unsigned char getParameter(int index);

    virtual int getParameterLength();

    virtual int getParameterOffset();
    
    bool convert(APIFrame * frame);
};

#endif
