#include "ATCommandIndicator.h"

ATCommandIndicator::ATCommandIndicator(APIFrame *frame)
    : RxBase(frame)
{ }

int ATCommandIndicator::getFrameID()
{
    return data[1];
}

unsigned char * ATCommandIndicator::getRequestCommand()
{
    return data + 2;
}

int ATCommandIndicator::getCommandStatus()
{
    return data[4];
}

unsigned  char * ATCommandIndicator::getParameter()
{
    if (getParameterLength() <= 0)
        return NULL;

    return data + 5;
}

unsigned char ATCommandIndicator::getParameter(int index)
{
    return data[5 + index];
}

int ATCommandIndicator::getParameterLength()
{
    return getPosition() - 5;
}

int ATCommandIndicator::getParameterOffset()
{
    return 5;
}

bool ATCommandIndicator::convert(APIFrame * frame)
{
    if (frame == NULL)
        return false;

    if (frame->getFrameType() != APIFrame::AT_Command_Response)
        return false;

    return APIFrame::convert(frame);
}

