#ifndef UK_AC_HERTS_SMARTLAB_XBEE_Pin
#define UK_AC_HERTS_SMARTLAB_XBEE_Pin

/// Base class for XBee module pin configuration
class Pin
{
private:
    static unsigned char bitfield[2];

    unsigned char num;

    char com[2];

    unsigned char IODet[2];

public:
    /**
    * Create a pin with its number, using this constructor means this pin has no IO functions.
    * @param number the number of the pin (0 - 20)
    */
    Pin(unsigned char number);

    /**
    * Create a pin with its number, using this constructor means this pin has IO functions.
    * @param number the number of the pin (0 - 20)
    * @param command the configure command for the pin (eg. 'D0')
    * @param changeDetection IO change dection bitmask configuration.
    */
    Pin(unsigned char number, const char * command, unsigned int changeDetection);
    
    // Get the pin number
    unsigned char getNumber();
    
    /// Get the configuration command
    const char * getCommand();
    
    /// Get the IO change detection bitmask for this pin
    const unsigned  char * getIODetection();
    
    /// Get the IO change detection bitmask for a set of pins.
    static const unsigned  char * IOChangeDetectionConfiguration(Pin ** pins, unsigned char size);

    /// Compare two pin and check if both are the same.
    friend bool operator ==(const Pin &a,const Pin &b);
    
    /// Compare two pin and check if both are the same.
    friend bool operator !=(const Pin &a,const Pin &b);
};

#endif