#include "ExplicitAddress.h"

ExplicitAddress::ExplicitAddress()
{ }

ExplicitAddress::ExplicitAddress (const unsigned  char * address, const unsigned  char * explicitAddress )
    : Address(address)
{
    memcpy(explicitValue, explicitAddress, 6);
}

ExplicitAddress::ExplicitAddress(long serialNumberHigh, long serialNumberLow, int networkAddress, int sourceEndpoint, int destinationEndpoint, int clusterID, int profileID)
    : Address(serialNumberHigh, serialNumberLow, networkAddress)
{
    explicitValue[0] = sourceEndpoint;
    explicitValue[1] = destinationEndpoint;
    explicitValue[2] = clusterID >> 8;
    explicitValue[3] = clusterID;
    explicitValue[4] = profileID >> 8;
    explicitValue[5] = profileID;
}

unsigned  char * ExplicitAddress::getExplicitValue()
{
    return explicitValue;
}

unsigned char ExplicitAddress::getSourceEndpoint()
{
    return explicitValue[0];
}

void ExplicitAddress::setSourceEndpoint(unsigned char SourceEndpoint)
{
    explicitValue[0] = SourceEndpoint;
}

unsigned char ExplicitAddress::getDestinationEndpoint()
{
    return explicitValue[1];
}

void ExplicitAddress::setDestinationEndpoint(unsigned char DestinationEndpoint)
{
    explicitValue[1] = DestinationEndpoint;
}

unsigned int ExplicitAddress::getClusterID()
{
    return (explicitValue[2] << 8) | explicitValue[3];
}

void ExplicitAddress::setClusterID(unsigned int ClusterID)
{
    explicitValue[2] = ClusterID >> 8;
    explicitValue[3] = ClusterID;
}

unsigned int ExplicitAddress::getProfileID()
{
    return (explicitValue[4] << 8) | explicitValue[5];
}

void ExplicitAddress::setProfileID(unsigned int ProfileID)
{
    explicitValue[4] = ProfileID >> 8;
    explicitValue[5] = ProfileID;
}