#ifndef UK_AC_HERTS_SMARTLAB_XBEE_IOSamples
#define UK_AC_HERTS_SMARTLAB_XBEE_IOSamples

#include "Pin.h"
#include <map>

using namespace std;
/**
* A collection of digital and analog samples reported by XBee module.
*/
class IOSamples
{
private :
    unsigned int SUPPLY_VOLTAGE;

    map<Pin *, unsigned int> analog;

    map<Pin *, unsigned char> digital;

public:
    /**
    * Get all the avaliable analog values.
    *
    * @returns map<Pin,int>
    */
    map<Pin *, unsigned int> * getAnalogs();

    /**
    * Get analog value from one pin.
    *
    * @param Pin XBee S1 or S2 pin object.
    * @returns 0xFFFF means sample not avaliable.
    */
    unsigned int getAnalog(Pin * pin);

    /**
    * Get all the avaliable digital values.
    *
    * @returns map<Pin,unsigned char>:
    *        LOW = 0,
    *        HIGH = 1,
    *        UNMONITORED = 2,
    */
    map<Pin *, unsigned char> * getDigitals();

    /**
    * Get digital value from one pin.
    *
    * @param Pin XBee S1 or S2 pin object.
    * @returns
    *      LOW = 0,
    *      HIGH = 1,
    *      UNMONITORED = 2,
    */
    unsigned char getDigital(Pin * pin);

    /**
    * Get supply voltage, S2 only.
    *
    * @returns voltage
    */
    unsigned int getSupplyVoltage();

    /**
    * Set supply voltage, S2 only.
    *
    * @param voltage
    */
    void setSupplyVoltage(unsigned int voltage);

    /**
    * Cleat all the sample values.
    */
    void clear();
};

#endif