#include "CreateSourceRouteRequest.h"

CreateSourceRouteRequest::CreateSourceRouteRequest(unsigned  char frameID, Address * remoteAddress, int * addresses, int size)
    : TxBase(12 + (size << 2), APIFrame::Create_Source_Route, frameID)
{
    sets(remoteAddress->getAddressValue(), 0, 10);
    set(0x00);
    setAddresses(addresses, size);
}

void CreateSourceRouteRequest::setRemoteAddress(Address * remoteAddress)
{
    sets(2, remoteAddress->getAddressValue(), 0, 10);
}

void CreateSourceRouteRequest::setAddresses(int * addresses, int size)
{
    setPosition(13);
    set(size);
    for (int i = 0; i< size; i++) {
        set(addresses[i] >> 8);
        set(addresses[i]);
    }
}