#include "RemoteCommandOptions.h"


RemoteCommandOptions::RemoteCommandOptions()
    : TransmitOptions()
{ }

RemoteCommandOptions::RemoteCommandOptions(unsigned char option)
    : TransmitOptions(option)
{ }

RemoteCommandOptions::RemoteCommandOptions(bool disable_retries_and_route_repair, bool apply_changes, bool enable_APS_encryption, bool use_extended_transmission_timeout)
    : TransmitOptions(disable_retries_and_route_repair, enable_APS_encryption, use_extended_transmission_timeout)
{
    if (apply_changes)
        value |= 0x02;
}

RemoteCommandOptions * RemoteCommandOptions::ApplyChanges =  new RemoteCommandOptions (0x02);

void RemoteCommandOptions::setApplyChanges(bool status)
{
    if (status)
        value |= 0x02;
    else
        value &= 0xFD;
}

bool RemoteCommandOptions::getApplyChanges()
{
    if (value & 0x02 == 0x02)
        return true;
    else return false;
}