#include "XBeeRx16Indicator.h"

XBeeRx16Indicator::XBeeRx16Indicator(APIFrame * frame)
    : RxBase(frame)
{ }

unsigned  char *  XBeeRx16Indicator::getReceivedData()
{
    if (getReceivedDataLength() <= 0)
        return NULL;

    return data + 5;
}

int  XBeeRx16Indicator::getReceivedDataOffset()
{
    return 5;
}

char  XBeeRx16Indicator::getReceivedData(int index)
{
    return data[5 + index];
}

int  XBeeRx16Indicator::getReceivedDataLength()
{
    return getPosition() - 5;
}

int  XBeeRx16Indicator::getRSSI()
{
    return data[3] * -1;
}

int  XBeeRx16Indicator::getReceiveStatus()
{
    return data[4];
}

Address  XBeeRx16Indicator::getRemoteDevice()
{
    return Address(NULL, data + 1);
}

bool  XBeeRx16Indicator::convert(APIFrame * frame)
{
    if (frame == NULL)
        return false;

    if (frame->getFrameType() != APIFrame::Rx16_Receive_Packet)
        return false;

    return APIFrame::convert(frame);
}