#include "RouteRecordIndicator.h"

RouteRecordIndicator::RouteRecordIndicator(APIFrame * frame)
    : RxBase(frame)
{  }

Address RouteRecordIndicator::getRemoteDevice()
{
    return Address(data + 1);
}

int RouteRecordIndicator::getReceiveStatus()
{
    return data[11];
}

int RouteRecordIndicator::getNumberOfAddresses()
{
    return data[12];
}

int RouteRecordIndicator::getAddresses(int index)
{
    if (index >= getNumberOfAddresses())
        return -1;

    return (data[13 + (index << 2)] << 8) | data[13 + (index << 2) + 1];
}

bool  RouteRecordIndicator::convert(APIFrame * frame)
{
    if (frame == NULL)
        return false;

    if (frame->getFrameType() != APIFrame::Route_Record_Indicator)
        return false;

    return APIFrame::convert(frame);
}