#ifndef UK_AC_HERTS_SMARTLAB_XBEE_ZigBeePins
#define UK_AC_HERTS_SMARTLAB_XBEE_ZigBeePins

#include "Pin.h"

/**
* Pin configuration information for XBee S2 modules.
*/
class ZigBeePins
{
public:

    /** VCC - - Power supply.
    * Poor power supply can lead to poor radio performance especially if the supply voltage is not kept within tolerance or is excessively noisy. To help reduce noise a 1uF and 8.2pF capacitor are recommended to be placed as near to pin1 on the PCB as possible. If using a switching regulator for your power supply, switching frequencies above 500 kHz are preferred. Power supply ripple should be limited to a maximum 50 mV peak to peak.
    */
    static Pin * P1_VCC;

    /// DOUT Output Output UART Data Out.
    static Pin * P2_DOUT;

    /// DIN / CONFIG(active low) Input Input UART Data In
    static Pin * P3_DIN_CONFIG;

    /// DIO12 Both Disabled Digital I/O 12.
    static Pin * P4_DIO12;

    /**
    * RESET Both Open-Collector with pull-up
    * Module Reset (reset pulse must be at least 200 ns).
    */
    static Pin * P5_RESET;

    /// RSSI PWM / DIO10 Both Output RX Signal Strength Indicator / Digital IO.
    static Pin * P6_RSSI_PWM_DIO10;

    /// DIO11 Both Input Digital I/O 11.
    static Pin * P7_PWM_DIO11;

    /// [reserved] - Disabled Do not connect.
    static Pin * P8_RESERVED;

    /// DTR(avtive low) / SLEEP_RQ/ DIO8 Both Input Pin Sleep Control Line or Digital IO 8.
    static Pin * P9_DTR_SLEEP_DIO8;

    /// GND - - Ground.
    static Pin * P10_GND;

    /// DIO4 Both Disabled Digital I/O 4.
    static Pin * P11_DIO4;

    /// CTS(active low) / DIO7 Both Output Clear-to-Send Flow Control or Digital I/O 7. CTS, if enabled, is an output.
    static Pin * P12_CTS_DIO7;

    /// ON / SLEEP(active low) Output Output Module Status Indicator or Digital I/O 9.
    static Pin * P13_ON_SLEEP;

    /// VREF Input - Not used for EM250. Used for programmable secondary processor. For compatibility with other XBee modules, we recommend connecting this pin voltage reference if Analog sampling is desired. Otherwise, connect to GND.
    static Pin * P14_VREF;

    /// Associate / DIO5 Both Output Associated Indicator, Digital I/O 5.
    static Pin * P15_ASSOCIATE_DIO5;

    /// RTS(active low) / DIO6 Both Input Request-to-Send Flow Control, Digital I/O 6. RTS, if enabled, is an input.
    static Pin * P16_RTS_DIO6;

    /// AD3 / DIO3 Both Disabled Analog Input 3 or Digital I/O 3.
    static Pin * P17_AD3_DIO3;

    /// AD2 / DIO2 Both Disabled Analog Input 2 or Digital I/O 2.
    static Pin * P18_AD2_DIO2;

    /// AD1 / DIO1 Both Disabled Analog Input 1 or Digital I/O 1.
    static Pin * P19_AD1_DIO1;

    /// AD0 / DIO0 / Commissioning Button Both Disabled Analog Input 0, Digital IO 0, or Commissioning Button.
    static Pin * P20_AD0_DIO0_COMMISSIONONG_BUTTON;
};

#endif