#include "SRF02.h"

SRF02::SRF02(uint8_t I2C_address,PinName sda, PinName scl): i2c_bus(sda,scl)
{
    deviceAddess =   I2C_address;
}

int SRF02::GetValue(uint8_t command, uint8_t mode)
{
    char w[2]= {COMMAND_REGISTER,command};
    if (i2c_bus.write(deviceAddess,w ,2)>=0)
        wait(DefaultWait);
    else return -1;
    char r[1] = {mode};
    if (i2c_bus.write(deviceAddess,r ,1)>=0)
        if (i2c_bus.read(deviceAddess, w, 2)>=0)
            return (w[0] << 8) | w[1];
    return -1;
}

int SRF02::GetMinimumRange()
{
    return GetValue(REAL_RANGING_CENTIMETERS,Autotune);
}

int SRF02::GetCentimeters()
{
    return GetValue(REAL_RANGING_CENTIMETERS,Range);
}

int SRF02::GetInches()
{
    return GetValue(REAL_RANGING_INCHES,Range);
}

int SRF02::GetMicroSeconds()
{
    return GetValue(REAL_RANGING_SECONDS,Range);
}

bool SRF02::ChangeAddress(uint8_t newAddress)
{
    char w[2]= {COMMAND_REGISTER,0xA0};
    if (i2c_bus.write(deviceAddess,w ,2)>=0)
        w[1] = 0xAA;
    else return false;
    if (i2c_bus.write(deviceAddess,w ,2)>=0)
        w[1] = 0xA5;
    else return false;
    if (i2c_bus.write(deviceAddess,w ,2)>=0)
        w[1] = newAddress;
    else return false;
    if (i2c_bus.write(deviceAddess,w ,2)>=0) {
        deviceAddess = newAddress;
        return true;
    }
    return false;
}
