#ifndef Smartlab_Drive_SP03
#define Smartlab_Drive_SP03

#include "mbed.h"
/**
* Example:
* @code
* #include "mbed.h"
* #include "SP03.h"
*
* DigitalOut myled(LED1);
* SP03 sp03(p28, p27);
*
* int main()
* {
*    sp03.setSpeed(SP03::SPEED_NORMAL);
*
*    sp03.setVolume(SP03::VOLUME_MAX);
*
*    while(1) {
*        if (!sp03.isSpeaking()) {
*            myled = 1;
*            sp03.speak("Hello CQ 1 2 2 3  4 6 76 7 9 9 08 8");
*        } else
*            myled = 0;
*    }
* }
* @endcode
*/
class SP03
{
private:
    static const char DEFAULT_ADDRESS = 0xC4;
    static const int CLOCK_RATE = 100000;
    static const char REGISTER_FOR_COMMAND = 0x00;
    static const char REGISTER_FOR_SOFTWARE_REVISION_NUMBER = 0x01;
    static const char SPEAK_OUT_THE_BUFFER = 0x40;

    static const char DEFAULT_SPEECH_PITCH = 0x03;
    
    char _volume;
    
    char _speed;

    I2C i2c_bus;
public :

    static const char SPEED_NORMAL  = 0x05;
    static const char SPEED_FAST = 0x02;
    static const char SPEED_SLOW = 0x06;

    static const char VOLUME_MAX = 0x00;
    static const char VOLUME_MEDIUM = 0x03;
    static const char VOLUME_MIN = 0x06;

    /** Construct
     *
     * @param sda I2C sda signal
     * @param scl I2C scl signal
     */
    SP03(PinName sda, PinName scl);

    /** Set the speed of the speech
     *
     * @param message NULL terminated char array
     */
    void speak(const char * message);

    /** Set the speed of the speech
     *
     * @param speed [SPEED_NORMAL = 0x05, SPEED_FAST = 0x02, SPEED_SLOW = 0x06]
     */
    void setSpeed(char speed);

    /** Set the volume of the speech
     *
     * @param volume [VOLUME_MAX = 0x00, VOLUME_MEDIUM = 0x03, VOLUME_MIN = 0x06]
     */
    void setVolume(char volume);

    /** Check if the SP03 is currently talking
     *
     * @returns
     *  ture device is talking and no command can be send,
     *  false command can be issued
     */
    bool isSpeaking();
};

#endif