#include "SP03.h"

SP03::SP03(PinName sda, PinName scl): i2c_bus(sda,scl)
{
    i2c_bus.frequency(CLOCK_RATE);
    _volume = VOLUME_MAX;
    _speed = SPEED_NORMAL;
}

void SP03::speak(const char * message)
{
    i2c_bus.start();
    i2c_bus.write(DEFAULT_ADDRESS);
    i2c_bus.write(REGISTER_FOR_COMMAND);
    i2c_bus.write(0x00);
    i2c_bus.write(_volume);
    i2c_bus.write(_speed);
    i2c_bus.write(DEFAULT_SPEECH_PITCH);
    int i = 0;
    while (true) {
        i2c_bus.write(message[i++]);
        if (message[i] == 0x00)
            break;
    }
    i2c_bus.write(0x00);
    i2c_bus.stop();

    i2c_bus.start();
    i2c_bus.write(DEFAULT_ADDRESS);
    i2c_bus.write(REGISTER_FOR_COMMAND);
    i2c_bus.write(SPEAK_OUT_THE_BUFFER);
    i2c_bus.stop();
}

void SP03::setSpeed(char speed)
{
    _speed = speed;
}

void SP03::setVolume(char volume)
{
    _volume = volume;
}

bool SP03::isSpeaking()
{
    i2c_bus.start();
    i2c_bus.write(DEFAULT_ADDRESS);
    i2c_bus.write(REGISTER_FOR_COMMAND);
    i2c_bus.stop();

    i2c_bus.start();
    i2c_bus.write(DEFAULT_ADDRESS | 0x01);
    int value = i2c_bus.read(0x00);
    i2c_bus.stop();

    if (value == 0x00)
        return false;
    else return true;
}