#ifndef UK_AC_HERTS_SMARTLAB_FM24V10
#define UK_AC_HERTS_SMARTLAB_FM24V10

#include "mbed.h"

class FM24V10
{
public :
    /*
    *The speed grades (standard mode: 100 kbit/s, full speed: 400 kbit/s, fast mode: 1 mbit/s, high speed: 3,2 Mbit/s) are maximum ratings. Compliant hardware guaranties that it can handle transmission speed up to the maximum clock rate specified by the mode.
    */
    enum SPEED_MODE {
        STANDARD,FULL,FAST,HIGH
    };

    FM24V10(PinName sda, PinName scl, bool A1, bool A2, SPEED_MODE speed = FULL);

    void WriteShort(int position, int value, bool Hs_mode = false);

    void WriteShort(int position, int * value, int size, bool Hs_mode = false);

    void ReadShort(int position, int * value, int size, bool Hs_mode = false);

    int ReadShort(int position, bool Hs_mode = false);

private :
    static const int HS_COMMAND = 0x09;

    static const int FREQUENCY_STANDARD = 100000;
    static const int FREQUENCY_FULL = 400000;
    static const int FREQUENCY_FAST = 1000000;
    static const int FREQUENCY_HIGH = 3200000;

    I2C _i2c_bus;
    int _speed;
    int _addr;

    int result;

    void Init(bool A1, bool A2);

    void GetSlaveAddress(int position);

    void StartHS();

    void StopHS();
};

#endif