#include "mbed.h"
#include <math.h>
#include "rtos.h"
#include "MMA8452.h"
#include <string>
#include "main.h"
 
MMA8452 acc(p28, p27, 100000);
Serial pc(USBTX,USBRX);
Serial BT(p9, p10);
DigitalOut led2(LED2);

Ticker BTtimer;
Timer globalTimer;
static float lat=0,lng=0,speed=0,accelerometer=0;
static int panic=0;
static double x;
//prototypes:
void BTsendInterval();

void DataReceived_ISR(){
     char globalChar = LPC_UART1->RBR;
}


void BTCommands (string cmd)
{
   
      
}

//GPS Thread
void thread1(void const *args)
{
    
    char c;
    while(true) {
       pc.printf("GPS Thread\n");
       if(gps.readable())
        { 
            if(gps.getc() == '$');           // wait a $
            {
                for(int i=0; i<sizeof(cDataBuffer); i++)
                {
                    c = gps.getc();
                    if( c == '\r' )
                    {
                        //pc.printf("%s\n", cDataBuffer);
                        parse(cDataBuffer, i);
                        i = sizeof(cDataBuffer);
                    }
                    else
                    {
                        cDataBuffer[i] = c;
                    }                 
                }
            }
         } 
              
        Thread::wait(100);
    }
}

void thread2(void const *args) //body thread
{
    
    while(true) { 
       if(!acc.isXReady()) {
         wait(0.01);
         continue;
         }
      acc.readXGravity(&x);
      pc.printf("ACCELERETOR Thread x:%lf \r\n",x);
        pc.printf("ACCELERETOR Thread\n");
        Thread::wait(100);
    }
    
}



void thread3(void const *args)
{
    
    while(true) { 
        BT.printf("Log %.6f,%.6f,%.1f,%.2f,%d\n",lat,lng,speed,accelerometer,panic);
        pc.printf("MQTT Thread\n");
        Thread::wait(100);
    }
}

void BTsendDegrees(float degree)
{
      BT.printf("lat:%f,lng:%f,speed:%f\n",lat,lng,speed);
}



void Init()
{
    gps.baud(9600);
    pc.baud(9600);
    BT.baud(9600);
    //BT.attach(&DataReceived_ISR,Serial::RxIrq); //maor
    wait(1); 
    pc.printf("Init OK\n");
}


int main()
{
    pc.printf("Main\n");
    Init();
    pc.printf("ready\n");
    Thread t1(thread1);
    t1.set_priority(osPriorityNormal);
    
    Thread t2(thread2);
    t2.set_priority(osPriorityNormal);
    
    Thread t3(thread3);
    t3.set_priority(osPriorityNormal);
    
    
    while(true) {       
    
    }
}

void parse(char *cmd, int n)
{
    
    char ns, ew, tf, status;
    int fq, nst, fix, date;                                     // fix quality, Number of satellites being tracked, 3D fix
    float latitude, longitude, timefix, spd, altitude;
    

    // Geographic position, Latitude and Longitude
    if(strncmp(cmd,"$GPRMC", 6) == 0) 
    {
        sscanf(cmd, "$GPRMC,%f,%c,%f,%c,%f,%c,%f,,%d", &timefix, &status, &latitude, &ns, &longitude, &ew, &spd, &date);
        lat=latitude/100;
        lng=longitude/100;
        speed=spd;
        pc.printf("GPS - Latitude: %f, Longitude: %f, Speed: %.1f\n", lat, lng, speed);
        //pc.printf("GPRMC Fix taken at: %f, Status: %c, Latitude: %f %c, Longitude: %f %c, Speed: %f, Date: %d\n", timefix, status, latitude, ns, longitude, ew, spd, date);
        
    }
}
