#ifndef USB_BULK_H
#define USB_BULK_H

#include "USBEndpoints.h"
#include "USBDescriptor.h"
#include "USBDevice_Types.h"

#include "USBBULK_Types.h"
#include "USBDevice.h"

/* Made By Shoichi Yamasuge     */
/* Operatration Movie           */
/* http://youtu.be/uGPH3AwrFpU  */

class USBBULK : public USBDevice {
public:
    USBBULK( uint16_t vendor_id, uint16_t product_id, uint16_t product_release );
    bool Write(uint8_t *Data);
    bool WriteNB(uint8_t *Data);
    bool read(uint8_t *Data);
    bool readNB(uint8_t *Data);

protected:
    virtual uint8_t * stringLangidDesc();
    virtual uint8_t * stringImanufacturerDesc();
    virtual uint8_t * stringIserialDesc();
    virtual uint8_t * stringIproductDesc();
    virtual uint8_t * stringIConfigurationDesc();
    virtual uint8_t * stringIinterfaceDesc();
    virtual uint8_t * configurationDesc();


    virtual bool USBCallback_setConfiguration(uint8_t configuration);
private:
    uint16_t VendorId;
    uint16_t ProductId;
    uint16_t ProductReleas;
};

#endif
