#include "stdint.h"
#include "USBHAL.h"
#include "USBBULK.h"

/* Made By Shoichi Yamasuge     */
/* Operatration Movie           */
/* http://youtu.be/uGPH3AwrFpU  */

USBBULK::USBBULK( uint16_t vendor_id, uint16_t product_id, uint16_t product_release ):USBDevice( vendor_id, product_id, product_release)
{
    VendorId      = vendor_id;
    ProductId     = product_id;
    ProductReleas = product_release;
}


bool USBBULK::Write( uint8_t *Data )
{
    return write(EPBULK_IN, Data, MAX_BULK_SIZE, MAX_BULK_SIZE);
}

bool USBBULK::WriteNB( uint8_t *Data )
{
    return writeNB(EPBULK_IN, Data, MAX_BULK_SIZE, MAX_BULK_SIZE);
}

bool USBBULK::read( uint8_t *Data )
{
    uint32_t bytesRead = 0;
    bool result;
    result = USBDevice::readEP(EPBULK_OUT, Data, &bytesRead, MAX_BULK_SIZE );
#if defined(TARGET_LPC11UXX)
    wait_us(100);                //Counter Mesure USB Bank Wait!?
#endif
     if(!readStart(EPBULK_OUT, MAX_BULK_SIZE ))
    {
        return false;
    }
 
    return result;
     
}

bool USBBULK::readNB( uint8_t *Data )
{
    uint32_t bytesRead = 0;
    bool result;
    result = USBDevice::readEP_NB(EPBULK_OUT, Data, &bytesRead, MAX_BULK_SIZE );
#if defined(TARGET_LPC11UXX)
    wait_us(100);                //Counter Mesure USB Bank Wait !?
#endif
    if(!readStart(EPBULK_OUT, MAX_BULK_SIZE ))
    {
        return false;
    }

    return result;
}


//
//  Route callbacks from lower layers to class(es)
//

#define DEFAULT_CONFIGURATION (1)


bool USBBULK::USBCallback_setConfiguration(uint8_t configuration)
{
    if (configuration != DEFAULT_CONFIGURATION)
    {
        return false;
    }

    addEndpoint(EPBULK_IN, MAX_PACKET_SIZE_EPINT);
    addEndpoint(EPBULK_OUT, MAX_PACKET_SIZE_EPINT);

    readStart(EPBULK_OUT, MAX_PACKET_SIZE_EPINT);
    return true;
}

uint8_t * USBBULK::stringLangidDesc() 
{
    static uint8_t stringLangidDescriptor[] =
    {
        0x04,               /*bLength*/
        0x03,               /*bDescriptorType 0x03*/
        0x09,
        0x04                /*bString Lang ID - 0x409 */
    };
    return stringLangidDescriptor;
}

uint8_t * USBBULK::stringImanufacturerDesc()
{
    static uint8_t stringImanufacturerDescriptor[] = {
        00,                                      /* Dummy Lenght */
        STRING_DESCRIPTOR,                        /*bDescriptorType 0x03*/
        'Y',0,
        'o',0,
        'u',0,
        'r',0,
        ' ',0,
        'C',0,
        'o',0,
        'm',0,
        'p',0,
        'a',0,
        'n',0,
        'y',0,
        ' ',0,
        'N',0,
        'a',0,
        'm',0,
        'e',0,
         0 ,0
    };
    stringImanufacturerDescriptor[0] = sizeof(stringImanufacturerDescriptor-2);
    return stringImanufacturerDescriptor;
}

uint8_t * USBBULK::stringIserialDesc()
{
    static uint8_t stringIserialDescriptor[] = {
        00,                                      /* Dummy Lenght */
        STRING_DESCRIPTOR,                                              /*bDescriptorType 0x03*/
        '0',0,
        '1',0,
        '2',0,
        '3',0,
        '4',0,
        '5',0,
        '6',0,
        '7',0,
        '8',0,
        '9',0,
         0,0
    };
    stringIserialDescriptor[0] = sizeof(stringIserialDescriptor)-2;                              // bLength
    return stringIserialDescriptor;
}


uint8_t * USBBULK::stringIproductDesc()
{
    static uint8_t stringIproductlDescriptor[] = {
        00,                                      /* Dummy Lenght */
        STRING_DESCRIPTOR,                                              /*bDescriptorType 0x03*/
        'U',0,
        's',0,
        'b',0,
        ' ',0,
        'B',0,
        'u',0,
        'l',0,
        'k',0,
        ' ',0,
        'P',0,
        'r',0,
        'o',0,
        'd',0,
        'u',0,
        'c',0,
        't',0,
         0,0
    };
    stringIproductlDescriptor[0] =   sizeof(stringIproductlDescriptor)-2;                          // bLength
    return stringIproductlDescriptor;
}
    
uint8_t * USBBULK::stringIConfigurationDesc()
{
    static uint8_t stringIconfigurationDescriptor[] = {
        00,                        //bLength
        STRING_DESCRIPTOR,  /*bDescriptorType 0x03*/
        '0',0,'1',0        /*bString iConfiguration - 01*/
    };
    stringIconfigurationDescriptor[0] = sizeof(stringIconfigurationDescriptor)-2;
    return stringIconfigurationDescriptor;
}


uint8_t * USBBULK::stringIinterfaceDesc() {
    static uint8_t stringIinterfaceDescriptor[] = {
        0,                        //bLength
        STRING_DESCRIPTOR,  //bDescriptorType 0x03
        'U',0,
        's',0,
        'b',0,
        ' ',0,
        'B',0,
        'u',0,
        'l',0,
        'k',0,
        ' ',0,
        'I',0,
        'n',0,
        't',0,
        'e',0,
        'r',0,
        'F',0,
        'a',0,
        'c',0,
        'e',0,
         0,0
    };
    stringIinterfaceDescriptor[0]  = sizeof(stringIinterfaceDescriptor)-2;                        //bLength
    return stringIinterfaceDescriptor;
}

#define DEFAULT_CONFIGURATION (1)

uint8_t * USBBULK::configurationDesc() {

    static uint8_t configurationDescriptor[] = {
/* *****Configuration Descriptor  ******** */
        CONFIGURATION_DESCRIPTOR_LENGTH,// bLength          (#9)
        CONFIGURATION_DESCRIPTOR,       // bDescriptorType  (#2)
        LSB(CONFIGURATION_DESCRIPTOR_LENGTH+INTERFACE_DESCRIPTOR_LENGTH+ENDPOINT_DESCRIPTOR_LENGTH*2),             // wTotalLength (LSB)
        MSB(CONFIGURATION_DESCRIPTOR_LENGTH+INTERFACE_DESCRIPTOR_LENGTH+ENDPOINT_DESCRIPTOR_LENGTH*2),             // wTotalLength (MSB)
        0x01,                           // bNumInterfaces
        DEFAULT_CONFIGURATION,          // bConfigurationValue
        0x00,                           // iConfiguration
        C_RESERVED | C_SELF_POWERED,    // bmAttributes
        C_POWER(250),                   // bMaxPower 250mA
/* ****** Interface Descriptor  ******** */
        INTERFACE_DESCRIPTOR_LENGTH,    // bLength          (#9)
        INTERFACE_DESCRIPTOR,           // bDescriptorType  (#4)
        0x00,                           // bInterfaceNumber: Number of Interface
        0x00,                           // bAlternateSetting: Alternate setting
        0x02,                           // bNumEndpoints: One endpoints used 
        VENDER_SPECIFIC_CLASS,          // bInterfaceClass: Communication Interface Class
        0x00,                           // bInterfaceSubClass
        0x00,                           // bInterfaceProtocol
        0x00,                           // iInterface
/* ****** EndPoint Descriptor   ******** */
        ENDPOINT_DESCRIPTOR_LENGTH,     // bLength          (#7)
        ENDPOINT_DESCRIPTOR,            // bDescriptorType  (#5)
        PHY_TO_DESC(EPBULK_IN),            // bEndpointAddress (#81)
        E_BULK,                         // bmAttributes     (#02)
        LSB(MAX_PACKET_SIZE_EPINT),     // wMaxPacketSize (LSB)
        MSB(MAX_PACKET_SIZE_EPINT),     // wMaxPacketSize (MSB)
        0,                              // bInterval (milliseconds 0:none..)

        ENDPOINT_DESCRIPTOR_LENGTH,     // bLength          (#7)
        ENDPOINT_DESCRIPTOR,            // bDescriptorType  (#5)
        PHY_TO_DESC(EPBULK_OUT ),       // bEndpointAddress (#02)
        E_BULK,                         // bmAttributes     (#02)
        LSB(MAX_PACKET_SIZE_EPINT),     // wMaxPacketSize (LSB)
        MSB(MAX_PACKET_SIZE_EPINT),     // wMaxPacketSize (MSB)
        0,                              // bInterval (milliseconds 0:none..)
    };
    return configurationDescriptor;
}
