#include "mbed.h"

#if    defined(TARGET_NUCLEO_L152RE) 
AnalogOut AOutL(PA_4);
AnalogOut AOutR(PA_5);
#elif  defined(TARGET_NUCLEO_F334R8)
AnalogOut AOutL(PA_4);
AnalogOut AOutR(PA_5);
AnalogOut AOutS(PA_6);
#endif
uint16_t i;
uint16_t SinTable[360];

int main() 
{
    float pi = 3.141592;
    for(i = 0 ; i < 360 ; i++)
    {
#if    defined(TARGET_NUCLEO_L152RE) 
        SinTable[i] =  (float)sin(pi*i/180.0F)*0x07ff+0x0800;
#elif  defined(TARGET_NUCLEO_F334R8)
        SinTable[i] =  (float)sin(pi*i/180.0F)*0x07ff+0x0800;
#endif
    }

    while(1) {
         for(i = 0 ; i < 360 ; i++)
         {
            AOutL.write_u16(SinTable[i]);
            AOutR.write_u16(SinTable[i]);
#if  defined(TARGET_NUCLEO_F334R8)
            AOutS.write_u16(SinTable[i]);
#endif
            wait_us(1); // 1 sec
          }
    }
}
