/**
[LV8548.h]
Copyright (c) [2018] [YAMASHO]
This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

#ifndef MBED_LV8548_H
#define MBED_LV8548_H

#include "mbed.h"

#define MAXCH   (2)

#define STEPMAX_FREQ (4800)
#define USE_PWM_PORT       (1) // if use stepper then (0)

/** Motor Use  */
 enum DriverType {
        DCMOTOR     /** DC Motor x2 */
      , STEPERMOTOR /** STEPER x1   */
};

enum DriverPwmMode {
          FWD_OPEN,    /** FWD_OPEN */
          FWD_BRAKE,   /** FWD_BREAKE   */
          RVS_OPEN,    /** REVERS OPEN */
          RVS_BRAKE    /** REVSRS BRAKE  */
};

enum DriverPwmOut {
          OUTPUT_OFF,    /* OFF */
          OUTPUT_START,  /*  START  */
          OUTPUT_BRAKE   /* BRAAKE */
};

/** Motor Number  */
 enum DriverMotorNumber {
        MOTOR_A   = 0      
      , MOTOR_B   = 1   
      , MOTOR_MAX
};


/** Motor Dirction  */
 enum DriverMotorDirction {
        DIR_CW   = 0      
      , DIR_CCW  = 1   
      , DIR_MAX
};

/** Motor Step Mode */
 enum DriverStepMode {
        FULLSTEP = 0      
      , HALFSTEP = 1   
      , MOTORSTEP_MAX
};

/** Motor Step Mode */
 enum DriverPhaseStep {
        STEPPHASE0 = 0,     
        STEPPHASE1 = 1,    
        STEPPHASE2 = 2,    
        STEPPHASE3 = 3,    
        STEPPHASE4 = 4,    
        STEPPHASE5 = 5,    
        STEPPHASE6 = 6,   
        STEPPHASE7 = 7,    
        STEPPHASEMAX = 8        /* 必ず8 */ 
};

class LV8548 {
public:
    LV8548(PinName in1, PinName in2, PinName in3, PinName in4, DriverType drivertype = DCMOTOR ,uint16_t baseus = 64);
#if USE_PWM_PORT
    PwmOut _in1,_in2,_in3,_in4;
#else
    DigitalOut _in1,_in2,_in3,_in4;
#endif
    DriverType   _Drivertype;
    uint16_t     _baseus; 
/***************************************************************************************************/
    DriverPwmMode _Pwmmode[MOTOR_MAX];  // pwmのモード FWD.OPEN FWD.BRAKE RVS.OPEN REV.BRAKE
    DriverPwmOut  _Pwmout [MOTOR_MAX];  // Start Stop Breke
    float _PwmPeriod      [MOTOR_MAX];  // ポートのPwm周波数
    float _PwmDuty        [MOTOR_MAX];  // 各Motor のduty 1.0f-0.0fまで
//   uint8_t _testx;
    
    Ticker _Lv8548BaseTimer;
    
    void SetDcPwmFreqency( uint8_t ch ,float Freq );
    void SetDcPwmMode( uint8_t ch ,DriverPwmMode  Mode );
    void SetDcPwmDuty( uint8_t ch ,float        Duty   );         // 01まで
    void SetDcOutPut ( uint8_t ch ,DriverPwmOut  Mode  );
    void SetDcMotor  ( uint8_t ch );
    void SetDcMotorStop( uint8_t ch );
/*******************************************************************************************************************/
    float _StepAngle;
    float _StepDeg;                      // 角度 0-360度
    float _StepFreq;                    // 周波数
    float _TimerCounter;                  
    volatile uint8_t _StepPhase;                   // Step Motorのphase
    volatile uint32_t _IntTimerCount;
//  volatile uint32_t _PhaseCounter;
    volatile uint32_t _StepTimeCount;
    volatile bool   _StepOperation;                       // 割込内の動作状況
    volatile DriverStepMode _TargetStepMode;              // 目標のStep状態  Full(0)/Half(1)
    volatile DriverStepMode _NowStepMode;                 // 動作中のStep状態  Full(0)/Half(1)
    volatile DriverMotorDirction _TragetStepDirection;         // 目標のDirection Cw/Ccw
    volatile DriverMotorDirction _NowStepDirection;            // 動作中のDirection cw/CCW
    volatile uint32_t _NowStep;                    // 現状のStep
    volatile uint32_t _TargetStep;                 // ターゲットのStep
    void SetStepAngle( uint16_t Angle);         // 角度の設定
    void SetStepDeg  ( uint16_t frequency , uint16_t deg  , uint8_t Direction, uint8_t StepMode);
    void SetStepTime ( uint16_t frequency , uint16_t time , uint8_t Direction, uint8_t StepMode);
    void SetStepStep ( uint16_t frequency , uint16_t step , uint8_t Direction, uint8_t StepMode);
    void SetStepStop ( void );
    void SetStepFree ( void );
    void SetStepMotor( void );
    void SetStepTimerInt ( void );
};


#endif
