#include "mbed.h"
#include "HX711.hpp"
#include "Dynamixel.h"

HX711 hx711(p21, p22);  //data, clk
Serial pc(USBTX, USBRX);
Dynamixel motor(p13,p14,p15,0xFE,57600);
Timer timeStamp;
int motorspeed = 0;
//--------------------HX711
void calibrate(float gram){
    hx711.setScale(1.f);
    hx711.tare();
    //この辺をProcessing用に組み替える
    printf("place the weight and push any button\n");
    char c = pc.getc();
    
    float natural = hx711.readGram();
    float calibVal = natural / gram;
    hx711.setScale(calibVal);
    printf("calibrated! %f %f %d\n", calibVal, natural, hx711.read());
}


//Dynamixel回転方向対応用
//多分11bitのうちMSBが符号,最上位で回転方向を指定している
void move(int speed){
    if(speed >= 0){
        motor.setSpeed(speed);
        //pc.printf("debugmode: %d\n", speed);//debug
    }
    else{
        motor.setSpeed(-1*speed+1024);  //11bitのうちMSBが符号
        //pc.printf("debugmode: %d\n", -1*speed+1024);//debug
    }
}

//シリアル受信時
void pc_rx(){
    char c = pc.getc(); //P5からの入力
    
    switch(c){
        case 'c':   //キャリブレーション
            calibrate(50.0);
            break;
        case 's':   //計測開始
            timeStamp.reset();
            move(motorspeed);  //(WIP)
            timeStamp.start();
            break;
        case 'e':   //計測終了
            move(0);    //(WIP)
            timeStamp.stop();
            break;
        case 'z':   //ゼロ点オフセット
            hx711.tare();
            break;
        case 'l':   //モータ左回転
            move(-1 * motorspeed);  //(WIP)
            break;
        case 'r':   //モータ右回転
            move(motorspeed);   //(WIP)
            break;
        case 'q':   //モータ停止
            move(0);
            break;
        
        case 'm':   //モータ速度設定
            char val_buf[20];   //数値受信用バッファ
            char rx_data;   //シリアル受信
            motorspeed = 0; //モータ速度を一旦初期化
            int i=0;
            do{
                rx_data = pc.getc();    //数値を取得
                val_buf[i] = rx_data;   //1文字を文字列に格納
                i++;
            }while(rx_data != ';'); //入力終了コマンド";"がきたら終了
            i=0;
            while(val_buf[i] != ';'){
                //int型に変換
                motorspeed *= 10;
                motorspeed += (val_buf[i] - '0');
                i++;
            }
            pc.printf("%d\n", motorspeed);
            //WIP
            break;
        
        default:
            pc.printf("fuck %c\n", c);
            break;
    }
}

int main() {
    pc.attach(pc_rx, Serial::RxIrq);
    pc.baud(115200);
    //ホイールモードにするための設定
    motor.setAngleLimit(0, ADDRESS_CW_ANGLE_LIMIT);
    motor.setAngleLimit(0, ADDRESS_CCW_ANGLE_LIMIT);
    move(0);
    
    float gram = 0;
    hx711.setScale(1.f);
    hx711.tare();
    
    timeStamp.reset();
    
    while(1) {
        gram = hx711.readGram(1);   //平均回数
        pc.printf(">%.4f,%.2f\n", gram, timeStamp.read()); //(WIP)Processingに送るデータ format: >(gram),(Time)
        //wait_ms(10);
    }
}
