#ifndef HX711_h
#define HX711_h

#include <mbed.h>

const float defautScale = 490000.0f;
const float lbToGram = 453.5f;

class HX711
{
  private:
    DigitalIn dataPin;
    DigitalOut clockPin;
    uint8_t gainPulse;
    uint32_t offset;
    float scale;
  public:
    HX711(PinName dataPinName, PinName clockPinName) :
      dataPin(dataPinName), clockPin(clockPinName, 0)
    {
      offset = 0;
      gainPulse = 1;
      scale = defautScale;
    }

    void tare() {
      offset = avg(10);
    }

    const float getOffset() {
      return offset;
    }

    float readGram(uint8_t times = 10) {
      float res = (float)avg(times) - offset;
      return res / scale /** lbToGram*/;
    }
    
    float readGram2(uint8_t times = 10) {
      float res = (float)avg(times) - offset;
      return res / scale;
    }

    uint32_t avg(uint8_t times = 10) {
      uint32_t res = 0;
      for(uint8_t i = 0; i < times; i++) {
        res += read();
      }
      return res / times;
    }

    bool isReady() {
      return dataPin == 0;
    }

    void setGainPulse(uint8_t _gainPulse) {
      gainPulse = _gainPulse;
      read();
    }

    void setScale(const float _scale) {
      scale = _scale;
    }

    const float getScale() {
      return scale;
    }

    uint32_t read() {
      uint32_t res = 0;
      uint8_t i = 0;

      while (!isReady());

      for(i = 0; i < 24; i++) {
        clockPin = 1;
        res = res << 1;
        clockPin = 0;
        if (dataPin == 1) {
          res++;
        }
      }

      for (int i = 0; i < gainPulse; i++) {
        clockPin = 1;
        clockPin = 0;
      }

      res ^= 0x00800000;
      return res;
    }
};

#endif