
#include "mbed.h"
#include "max7219.h" 
#define HIGHT  15
#define WIDTH  15
Max7219 device(PTD2, PTD3, PTD1, PTD0);
uint16_t  DotArea[] = {
  0b0101111111111111,
  0b0100000000000001,
  0b0101010101010101,
  0b0100000000000001,
  0b0101010101010101,
  0b0100000000000001,
  0b0101010101010101,
  0b0100000000000001,
  
  0b0101010101010101,
  0b0100000000000001,
  0b0101010101010101,
  0b0100000000000001,
  0b0101010101010101,
  0b0100000000000001,
  0b0111111111111101,
  0b0000000000000000
};
const uint16_t  DotAreaTemp[] = {
  0b0101111111111111,
  0b0100000000000001,
  0b0101010101010101,
  0b0100000000000001,
  0b0101010101010101,
  0b0100000000000001,
  0b0101010101010101,
  0b0100000000000001,
  
  0b0101010101010101,
  0b0100000000000001,
  0b0101010101010101,
  0b0100000000000001,
  0b0101010101010101,
  0b0100000000000001,
  0b0111111111111101,
  0b0000000000000000
};
AnalogIn   ain(A0);
void sendArray();
 
int main(){
    const int device_number = 4;
     
    device.set_num_devices(device_number);
    
    max7219_configuration_t cfg = {
            .device_number = device_number,
            .decode_mode = 0,
            .intensity = Max7219::MAX7219_INTENSITY_5,
            .scan_limit = Max7219::MAX7219_SCAN_8
    };
    
    device.init_display(cfg);
    device.enable_display();
    device.set_display_test();
    wait(1);
    device.clear_display_test();
    
    
    
    while(1){
        sendArray();
        wait(4);
        uint8_t i, j, val, mod;
        int8_t  x, y;

        // Maze Make
        mod = 4;
        for (i = 2; i < HIGHT - 2; i += 2) {
            for (j = 3; j < WIDTH - 1; j += 2) {
                DotArea[i] |= (0x8000 >> j);
                do{
                    //Roll a stick
                    val = (uint8_t)(ain.read_u16() & 0x00FF) % mod;
                    x = 0, y = 0;
                    if (val == 0)y = 1;
                    if (val == 1)x = -1;
                    if (val == 2)x = 1;
                    if (val == 3)y = -1;
                }while ((DotArea[i + y] & (0x8000 >> (j + x)))); 
                DotArea[i + y] |= (0x8000 >> (j + x));
            }
            mod = 3;
        }
        sendArray();
        wait(10);
        
        for(int i = 0; i < 16;i++)
        {
            DotArea[i] = DotAreaTemp[i];
        }
    }
}

void sendArray()
{  
    for(int i = 0; i < 8;i++)
    {
        device.write_digit(1,i+1, (uint8_t)(DotArea[i] / 256));
    }

    for(int i = 0; i < 8;i++)
    {
        device.write_digit(2,i+1, (uint8_t)(DotArea[i+8] / 256));
    }

    for(int i = 0; i < 8;i++)
    {
        device.write_digit(3,i+1, (uint8_t) (DotArea[i]));
    }
    for(int i = 0; i < 8;i++)
    {
        device.write_digit(4,i+1, (uint8_t) (DotArea[i+8]));
    }
}


