#include "mbed.h"

void printTime(int n) {
    printf("\n");

    time_t prev = time(NULL);
    while (n > 0) {
        time_t seconds = time(NULL);
        if (prev != seconds) {
            char buf[32];
            strftime(buf, sizeof(buf), "%x %X", localtime(&seconds));
            printf("%s\n", buf);
            prev = seconds;
            n--;
        }
    }
}

void adjustTime() {
    int n1, n2, n3, n4, n5, n6;
    struct tm t;

    printf("\nEnter current time (yy/mm/dd hh:mm:ss)\n");

    scanf("%d / %d / %d %d : %d : %d", &n1, &n2, &n3, &n4, &n5, &n6);
    t.tm_sec = n6;
    t.tm_min = n5;
    t.tm_hour = n4;
    t.tm_mday = n3;
    t.tm_mon = n2 - 1;
    t.tm_year = n1 + 100;

    set_time(mktime(&t));
}

int main() {
    if (time(NULL) == (time_t) -1) {
        set_time(0);
    }

    printf("Adjust RTC - Enter t or T\n");

    while (true) {
        switch (getchar()) {
            case 'T':
                adjustTime();
                break;
            case 't':
                printTime(5);
                break;
        }
    }
}