#include "mbed.h"

AnalogIn x(p15);
AnalogIn y(p16);
AnalogIn z(p17);
DigitalIn zeroGDetect(p25);
DigitalOut gSelect(p26);
DigitalOut sleep(p24);

int main() {
    gSelect = 1; // 6g mode
    sleep = 1;   // do not sleep

    while (true) {
        float accelX = (x.read() * 3.3 - 1.65) / 0.206;
        float accelY = (y.read() * 3.3 - 1.65) / 0.206;
        float accelZ = (z.read() * 3.3 - 1.65) / 0.206;
        printf("x = %5.3f, y = %5.3f, z = %5.3f\n", accelX, accelY, accelZ);
        wait(1.0);
    }
}