#include "mbed.h"
#include "MMA7361L.h"

DigitalIn pressed(p20);
MMA7361L accel(p15, p16, p17, p25, p26, p24);
LocalFileSystem local("local");
BusOut leds(LED1, LED2, LED3, LED4);

void logAccel(FILE *fp, MMA7361L& accel) {
    char timestamp[32];

    time_t seconds = time(NULL);
    strftime(timestamp, sizeof(timestamp), "%X", localtime(&seconds));

    fprintf(fp, "%s %5.3f %5.3f %5.3f %5.3f\n",
            timestamp, accel.getAccel(),
            accel.getAccelX(), accel.getAccelY(), accel.getAccelZ());
}

int main() {
    for (int i = 0; !pressed; i = (i + 1) % 2)  {
        leds = i;
        wait(0.2);
    }
    leds = 15;
    wait(1);

    accel.setScale(MMA7361L::SCALE_6G);
    FILE *fp = fopen("/local/accel.txt", "w");

    for (int i = 0; !pressed; i = (i + 1) % 4) {
        logAccel(fp, accel);

        leds = 1 << i;
        wait(0.5);
        leds = 0;
        wait(0.5);
    }
    
    fclose(fp);

    leds = 15;
    wait(1);
    leds = 0;
}