#include "mbed.h"
#include "MMA7361L.h"

DigitalIn pressed(p20);
MMA7361L accel(p15, p16, p17, p25, p26, p24);
LocalFileSystem local("local");

void logAccel(FILE *fp, MMA7361L& accel) {
   char timestamp[32];

   time_t seconds = time(NULL);
   strftime(timestamp, sizeof(timestamp), "%X", localtime(&seconds));

   fprintf(fp, "%s %5.3f %5.3f %5.3f %5.3f\n",
           timestamp, accel.getAccel(),
           accel.getAccelX(), accel.getAccelY(), accel.getAccelZ());
}

int main() {
   accel.setScale(MMA7361L::SCALE_6G);
   FILE *fp = fopen("/local/accel.txt", "w");

    while (!pressed) {
        logAccel(fp, accel);
        wait(1.0);
    }

    fclose(fp);
}