#ifndef MBED_YMZ294_H
#define MBED_YMZ294_H

#include "mbed.h"

enum Channel {CHANNEL_A = 0, CHANNEL_B, CHANNEL_C};

enum Mixer {NONE = 0x3F,
            TONE_A = ~(1 << 0), TONE_B = ~(1 << 1), TONE_C = ~(1 << 2),
            NOISE_A = ~(1 << 3), NOISE_B = ~(1 << 4), NOISE_C = ~(1 << 5)
           };

class YMZ294 {
public:
    YMZ294(PinName dataPin0, PinName dataPin1, PinName dataPin2, PinName dataPin3,
           PinName dataPin4, PinName dataPin5, PinName dataPin6, PinName dataPin7,
           PinName csPin, PinName wrPin, PinName a0Pin);
    void setTone(Channel channel, float freq);
    void setVolume(Channel channel, int volume);
    void setNoise(int freq);
    void setEnvelope(int freq, int shape);
    void setMixer(Mixer m0, Mixer m1 = NONE, Mixer m2 = NONE, Mixer m3 = NONE, Mixer m4 = NONE, Mixer m5 = NONE);
private:
    void write(char data, bool dataWrite = false);
    void writeData(char address, int data, int nBytes = 1);

    BusOut dataPins;
    DigitalOut csPin;
    DigitalOut wrPin;
    DigitalOut a0Pin;
    char volumes[3];
    float freqs[3];
    float noiseFreq;
};
#endif