#include "YMZ294.h"

const int ADDR_FREQ[] = {0, 2, 4};
const int ADDR_NOISE = 6;
const int ADDR_MIXER = 7;
const int ADDR_VOL[] = {8, 9, 10};
const int ADDR_ENV_FREQ = 11;
const int ADDR_ENV_SHAPE = 13;

YMZ294::YMZ294(PinName dataPin0, PinName dataPin1, PinName dataPin2, PinName dataPin3,
               PinName dataPin4, PinName dataPin5, PinName dataPin6, PinName dataPin7,
               PinName csPin, PinName wrPin, PinName a0Pin) :
        dataPins(dataPin0, dataPin1, dataPin2, dataPin3, dataPin4, dataPin5, dataPin6, dataPin7),
        csPin(csPin), wrPin(wrPin), a0Pin(a0Pin) {}

void YMZ294::setTone(Channel channel, float freq) {
    if (freqs[channel] != freq) {
        int tp = 125000.0 / freq; // tp <= 4095 or freq > 30.525
        writeData(ADDR_FREQ[channel], tp, 2);
        freqs[channel] = freq;
    }
}

void YMZ294::setVolume(Channel channel, int volume) {
    if (volumes[channel] != volume || volume == 16) {
        writeData(ADDR_VOL[channel], volume & 0x1F);
        volumes[channel] = volume;
    }
}

void YMZ294::setNoise(int freq) {
    if (noiseFreq != freq) {
        writeData(ADDR_NOISE, freq & 0x1F);
        noiseFreq = freq;
    }
}

void YMZ294::setEnvelope(int freq, int shape) {
    writeData(ADDR_ENV_FREQ, freq, 2);
    writeData(ADDR_ENV_SHAPE, shape);
}

void YMZ294::setMixer(Mixer m0, Mixer m1, Mixer m2, Mixer m3, Mixer m4, Mixer m5) {
    writeData(ADDR_MIXER, m0 & m1 & m2 & m3 & m4 & m5);
}

void YMZ294::write(char data, bool dataWrite) {
    wrPin = 0;
    csPin = 0;
    a0Pin = dataWrite;
    dataPins = data;
    wrPin = 1;
    csPin = 1;
}

void YMZ294::writeData(char address, int data, int nBytes) {
    write(address);
    write(data & 0xFF, true);
    while (--nBytes) {
        write(++address);
        write((data >>= 8) & 0xFF, true);
    }
}