#include "mbed.h"

struct Function {
    char *description;
    void (*func)();
};

void xbee01();
void xbee02();
void xbee03();
void xbee04();
void xbee05();
void xbee06();
void xbee07();
void xbee08();
void xbee09();
void xbee10();
void xbee11();
void xbee_io01();
void xbee_io02();
void xbee_io03();
void xbee_io04();
void xbee_io05();
void xbee_io06();
void xbee_io07();
void xbee_enddev01();
void xbee_enddev02();
void xbee_enddev03();
void xbee_enddev04();
void xbee_enddev05();
void xbee_enddev06();
void xbee_enddev07();
void xbee_enddev08();
void xbee_at_command();
void xbee_network_reset();

Function functions[] = {
    "function description", 0,
    "XBee01 - Firmware Version", xbee01,
    "XBee02 - AT Command Executions", xbee02,
    "XBee03 - Changing PAN ID", xbee03,
    "XBee04 - Receiver (receive & dump)", xbee04,
    "XBee05 - Router (send hello 10 times)", xbee05,
    "XBee06 - Router (send hello and check if it succeeds)", xbee06,
    "XBee07 - Coordinator (receive and scan sender's addresses)", xbee07,
    "XBee08 - Coordinator (receive and retrieve RSSI values)", xbee08,
    "XBee09 - Router (send greetings to destination and wait for reply)", xbee09,
    "XBee10 - Router (receive greetings and reply)", xbee10,
    "XBee11 - Router (broadcast, send and receive to/from others)", xbee11,
    "XBeeIO01 - IO (blink an LED connected to DIO12)", xbee_io01,
    "XBeeIO02 - Remote IO (blink an LED connected to DIO12)", xbee_io02,
    "XBeeIO03 - IO Sampling (execute IS command to read AD1 & DIO4)", xbee_io03,
    "XBeeIO04 - Remote IO Sampling (execute IS command to read AD1 & DIO4", xbee_io04,
    "XBeeIO05 - Remote IO Sampling (use IOSample object to get AD1)", xbee_io05,
    "XBeeIO06 - IO Sampling (send IO sampling every second)", xbee_io06,
    "XBeeIO07 - Temperature Sampling Receiver", xbee_io07,
    "XBeeEndDev01 - Node Identifier", xbee_enddev01,
    "XBeeEndDev02 - Sleep Mode", xbee_enddev02,
    "XBeeEndDev03 - Sleep Time", xbee_enddev03,
    "XBeeEndDev04 - Query on Sleep (w/o sleep_rq)", xbee_enddev04,
    "XBeeEndDev05 - Query on Sleep (w/ sleep_rq)", xbee_enddev05,
    "XBeeEndDev06 - NodeIdentificationIndicator", xbee_enddev06,
    "XBeeEndDev07 - Button Event", xbee_enddev07,
    "XBeeEndDev08 - Extended Sleep", xbee_enddev08,

    "AT Command Executor", xbee_at_command,
    "Network Reset (issue NR0 command)", xbee_network_reset,
    0, 0
};
