#include "XBee.h"

void printNetInfo(XBee& xbee) {
    printf("OP: %s\n", (char *) XBeeAddress64(*(uint64_t *) xbee.executeCommand("OP")));
    printf("OI: %s\n", (char *) XBeeAddress16(*(uint16_t *) xbee.executeCommand("OI")));
    printf("CH: %d\n", *(uint8_t *) xbee.executeCommand("CH"));
}

int receiveModemStatus(XBee& xbee) {
    if (xbee.receive() == XBee::ModemStatus) {
        XBeeStatus status;
        if (xbee.scan(status)) {
            const char *modemStatus[] = {
                "Hardware reset", // 0
                "Watchdog timer reset", // 1
                "Joined network (routers and end devices)", // 2
                "Disassociated", // 3
                "?", "?",  // 4, 5
                "Coordinator started" // 6
            };
            printf("Modem Status = %s\n", status < 7 ? modemStatus[status] : "?");
        }
        return status;
    }
    return -1;
}

void xbee_network_reset() {
    XBee xbee(p9, p10);
    xbee.baud(9600);

    printf("*** Network Reset ***\n");

    if (xbee.init()) {
        printNetInfo(xbee);

        printf("Issuing NR0 command...\n");
        xbee.sendCommand("NR", 0);

        // wait for XBee to join network
        while (receiveModemStatus(xbee) != 2)
            ;
        printNetInfo(xbee);
    } else {
        printf("XBee connection error");
    }

}