#include "XBee.h"

void xbee_io07() {
    XBee xbee(p9, p10);
    xbee.baud(115200);
    xbee.init();

    printf("*** Receiver ***\n");

    while (true) {
        if (xbee.receive() == XBee::ZigBeeIODataSampleRxIndicator) {
            XBeeAddress64 address;
            XBeeReceivedData data(16);
            xbee.scan(address);
            xbee.scan(data);
            IOSample sample(data);
            float ad1 = 1.2 * sample.ad[1] / 1023;
            float temperature = (ad1 - 0.424) / 0.00625;
            printf("%s: temperature = %3.1f\n", (char *) address, temperature);
        }
    }
}