#include "XBee.h"

void xbee_io05() {
    XBee xbee(p9, p10);
    xbee.baud(115200);
    xbee.init();

    xbee.setDestination(XBeeAddress64(0x0013A200, 0x40310E99));

    xbee.sendRemoteCommand("D1", 2); // analog input
    while (xbee.receive());          // clear receive buffer

    for (int i = 0; i < 60; i++) {
        xbee.sendRemoteCommand("IS");
        if (xbee.receive() == XBee::RemoteCommandResponse) {
            XBeeCommandData data(16);
            xbee.scan(data);
            
            IOSample sample(data);
            printf("AD1 = %3.2fV\n", 1.2 * sample.ad[1] / 1023);
        }
        wait(1);
    }

    printf("done.\n");
}