#include "XBee.h"

void xbee_enddev07() {
    XBee xbee(p9, p10);
    xbee.baud(115200);
    xbee.init();

    while (true) {
        if (xbee.receive() == XBee::NodeIdentificationIndicator) {
            XBeeAddress64 address64;
            XBeeSourceEvent event;
            
            xbee.scan(address64);
            xbee.scan(event);
            
            if (event == 1) {
                xbee.setDestination(address64);
                xbee.sendRemoteCommand("SP", 2000);
                xbee.sendRemoteCommand("SN", 1);
                xbee.sendRemoteCommand("ST", 1000);             
                xbee.sendRemoteCommand("D1", 2);
                xbee.sendRemoteCommand("IR", 60000);
                printf("* %s: parameters set\n", (char *) address64);
            } 
        } else {
            xbee.dump();
        }
    }
}