#include "XBee.h"

void xbee_at_command() {
    XBee xbee(p9, p10);
    xbee.baud(115200);
    xbee.init();

    while (true) {
        printf("Enter AT command or q (quit) => ");
        char command[32], param[32] = {};
        int length = 0;
        scanf("%s", command);
        if (command[0] == 'q')
            break;
        if (command[2]) {
            if ((command[0] == 'N' && command[1] == 'I') ||
                (command[0] == 'N' && command[1] == 'D') ||
                (command[0] == 'D' && command[1] == 'N')) {
                while ((param[length] = command[length + 2]) != 0)
                    length++;
            } else {
                if (command[2] == '0' && (command[3] == 'x' || command[3] == 'X')) {
                    length = strlen(&command[4]);
                    if (length <= 2) {
                        length = 1;
                        sscanf(&command[4], "%hhX", (char *) param);
                    } else if (length <= 4) {
                        length = 2;
                        unsigned short us;
                        sscanf(&command[4], "%hX", &us);
                        param[1] = (us >> 0) & 0xFF;
                        param[0] = (us >> 8) & 0xFF;
                    } else if (length <= 8) {
                        length = 4;
                        unsigned long ul;
                        sscanf(&command[4], "%X", &ul);
                        param[3] = (ul >> 0) & 0xFF;
                        param[2] = (ul >> 8) & 0xFF;
                        param[1] = (ul >> 16) & 0xFF;
                        param[0] = (ul >> 24) & 0xFF;
                    } else {
                        length = 8;
                        unsigned long long ull;
                        sscanf(&command[4], "%llX", &ull);
                        param[7] = (ull >> 0) & 0xFF;
                        param[6] = (ull >> 8) & 0xFF;
                        param[5] = (ull >> 16) & 0xFF;
                        param[4] = (ull >> 24) & 0xFF;
                        param[3] = (ull >> 32) & 0xFF;
                        param[2] = (ull >> 40) & 0xFF;
                        param[1] = (ull >> 48) & 0xFF;
                        param[0] = (ull >> 56) & 0xFF;
                    }
                } else {
                    unsigned short us;
                    sscanf(&command[2], "%hd", &us);
                    if (us < 256) {
                        length = 1;
                        param[0] = us;
                    } else {
                        length = 2;
                        param[1] = (us >> 0) & 0xFF;
                        param[0] = (us >> 8) & 0xFF;
                    }
                }
            }
        }
        command[2] = '\0';

        xbee.sendCommand(command, param, length);

        while (xbee.receive())
            xbee.dump();
    }
    printf("done.\n");
}