#include "XBee.h"

void xbee11() {
    XBee xbee(p9, p10);
    xbee.baud(115200);
    xbee.init();

    xbee.setDestination(BROADCAST);

    while (xbee.receive(5) != XBee::ZigBeeReceivePacket) {
        xbee.printf("Hello?");
        printf("sent: Hello?\n");
    }

    do {
        XBeeAddress64 address64;
        XBeeReceivedData data(64);

        xbee.scan(address64);
        xbee.scan(data);
        
        printf("received from %s: %s\n", (char *) address64, (char *) data);

        if (strcmp(data, "Hello?") == 0) {
            xbee.setDestination(address64);
            xbee.printf("Hello!");
        }
    } while (xbee.receive(0) == XBee::ZigBeeReceivePacket);
}