/*
Copyright (c) 2013, Senio Networks, Inc.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "XBeeDataTypes.h"

XBeeAddress64::XBeeAddress64() : address64() {
}

XBeeAddress64::XBeeAddress64(const char *address) {
    memcpy(address64, address, 8);
}

XBeeAddress64::XBeeAddress64(uint64_t address) {
    uint64_t a = address;
    for (int i = 0; i < 8; i++, a >>= 8)
        address64[7 - i] = a & 255; 
}

XBeeAddress64::XBeeAddress64(uint32_t high, uint32_t low) {
    uint64_t a = uint64_t(high) << 32 | uint64_t(low);
    for (int i = 0; i < 8; i++, a >>= 8)
        address64[7 - i] = a & 255; 
}

XBeeAddress64::operator uint64_t() {
    uint64_t a = address64[0];
    for (int i = 1; i < 8; i++) {
        a <<= 8;
        a |= address64[i];
    }
    return a;
}

bool XBeeAddress64::operator ==(XBeeAddress64& addr) {
    return *(uint64_t *) address64 == *(uint64_t *) (addr.address64);
}

bool XBeeAddress64::operator ==(const char* addr) {
    return *(uint64_t *) address64 == *(uint64_t *) addr;
}

bool XBeeAddress64::operator ==(uint64_t addr) {
    return *(uint64_t *) address64 == addr;
}

XBeeAddress64::operator char *() {
    sprintf(buf, "%02X%02X%02X%02X %02X%02X%02X%02X", 
    address64[0], address64[1], address64[2], address64[3],
    address64[4], address64[5], address64[6], address64[7]);

    return buf;
}

XBeeAddress16::XBeeAddress16() : address16() {
}

XBeeAddress16::XBeeAddress16(const char *address) {
    memcpy(address16, address, 2);
}

XBeeAddress16::XBeeAddress16(uint16_t address) {
    address16[0] = (address >> 8) & 255;
    address16[1] = address & 255;
}

XBeeAddress16::XBeeAddress16(char high, char low) {
    address16[0] = high;
    address16[1] = low;
}

XBeeAddress16::operator uint16_t() {
    return uint16_t(address16[0]) << 8 | uint16_t(address16[0]);
}

bool XBeeAddress16::operator ==(XBeeAddress16& addr) {
    return *(uint16_t *) address16 == *(uint16_t *) (addr.address16);
}

bool XBeeAddress16::operator ==(const char* addr) {
    return *(uint16_t *) address16 == *(uint16_t *) addr;
}

bool XBeeAddress16::operator ==(uint16_t addr) {
    return *(uint16_t *) address16 == addr;
}

XBeeAddress16::operator char *() {
    sprintf(buf, "%02X%02X", address16[0], address16[1]);
    return buf;
}

XBeeData::XBeeData(int capacity) : capacity(capacity), size(0) {
    data = new char[capacity]();
}

XBeeData::~XBeeData() {
    delete[] data;
}

BitArray::BitArray(int mask, int values) : mask(mask), values(values) {
}

int BitArray::operator [](int i) const {
    return valueAt(i);
}

int BitArray::valueAt(int i) const {
    return (mask & 1 << i) ? (values >> i) & 1 : -1;
}

IntArray::IntArray(int mask, const char *values) : mask(mask), values(values) {
}

int IntArray::operator [](int i) const {
    return valueAt(i);
}

int IntArray::valueAt(int i) const {
    if (mask & 1 << i) {
        int count = 0;
        for (int j = 0; j < i; j++) {
            if (mask & 1 << j) count++;
        }
        const char *p = values + 2 * count;
        return (p[0] << 8) | p[1];
    } else {
        return -1;
    }
}

IOSample::IOSample(const char *data)
    : dio((data[1] << 8 | data[2]), (data[1] << 8 | data[2]) ? (data[4] << 8 | data[5]) : 0),
      ad(data[3], (data[1] << 8 | data[2]) ? data + 6 : data + 4) {
}

IOSample::operator char *() {
    bool first = true;
    char *p = buf;
    
    for (int i = 0; i < 16; i++) {
        if (dio[i] != -1) {
            if (first) {
                first = false;
                p += sprintf(p, "DIO%d=%d", i, dio[i]);
            } else {
                p += sprintf(p, ", DIO%d=%d", i, dio[i]);
            }
        }
    }

    for (int i = 0; i < 8; i++) {
        if (ad[i] != -1) {
            if (first) {
                first = false;
                p += sprintf(p, "AD%d=%d", i, ad[i]);
            } else {
                p += sprintf(p, ", AD%d=%d", i, ad[i]);
            }
        }
    }    
    return buf;
}
