/*
Copyright (c) 2011, Senio Networks, Inc.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "XBee.h"

bool XBee::scan(ValueType type, char *value, int maxlength, int *length) {
    if (received != out || (in == out && free != 0))
        return false;

    return scan(out, type, value, maxlength, length);
}

bool XBee::scan(int index, ValueType type, char *value, int maxlength, int *length) {
    int from = 0;
    int len = 1;
    FrameType frameType = getFrameType(buf[INDEX(index + 2)]);

    if (frameType == (FrameType) None)
        return false;

    switch (type) {
        case FrameID:
            from = 1;
            break;
        case ATCommand:
            switch (frameType) {
                case ATCommandResponse:
                    from = 2;
                    break;
                case RemoteCommandResponse:
                    from = 12;
                    break;
            }
            len = 2;
            break;
        case Status:
            switch (frameType) {
                case ATCommandResponse:
                    from = 4;
                    break;
                case ModemStatus:
                    from = 1;
                    break;
                case RemoteCommandResponse:
                    from = 14;
                    break;
            }
            break;
        case CommandData:
            switch (frameType) {
                case ATCommandResponse:
                    from = 5;
                    len = SIZE(buf, index) - 5;
                    break;
                case RemoteCommandResponse:
                    from = 15;
                    len = SIZE(buf, index) - 15;
                    break;
            }
            break;
        case Address16:
            switch (frameType) {
                case ZigBeeTransmitStatus:
                    from = 4;
                    break;
                case ZigBeeReceivePacket:
                case ZigBeeIODataSampleRxIndicator:
                    from = 9;
                    break;
                case RemoteCommandResponse:
                    from = 10;
                    break;
            }
            len = 2;
            break;
        case Address64:
            switch (frameType) {
                case ZigBeeReceivePacket:
                case ZigBeeIODataSampleRxIndicator:
                    from = 1;
                    break;
                case RemoteCommandResponse:
                    from = 2;
                    break;
            }
            len = 8;
            break;
        case RetryCount:
            from = 4;
            break;
        case DeliveryStatus:
            from = 5;
            break;
        case DiscoveryStatus:
            from = 6;
            break;
        case ReceiveOptions:
            from = 11;
            break;
        case ReceivedData:
            from = 12;
            len = SIZE(buf, index) - 12;
            break;
        case RawData:
            from = 1;
            len = SIZE(buf, index) - 1;
            break;
    }

    if (from > 0) {
        copy(value, INDEX(index + 2 + from), min(len, maxlength));
        if (length) *length = len;
        return true;
    } else
        return false;
}