/*
Copyright (c) 2011, Senio Networks, Inc.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "XBee.h"
#include <ctype.h>

void XBee::dump() {
    if (received != out || (in == out && free != 0))
        return;

    switch (getFrameType(buf[INDEX(out + 2)])) {
        case ATCommandResponse: {
            char id, name[2], status, data[16];
            int length = 0;
            scan(FrameID, &id);
            scan(ATCommand, name, sizeof(name));
            scan(Status, &status);
            scan(CommandData, data, sizeof(data), &length);
            mon.printf("ATCommandResponse, Id=%d, Nm=%c%c, St=%02X, ", id & 255, name[0], name[1], status);
            if (name[0] == 'I' && name[1] == 'S' && status == 0)
                dumpIOSample(data, length);
            else
                dump(data, length);
        }
        break;

        case ModemStatus: {
            char status;
            scan(Status, &status);
            mon.printf("ModemStatus, St=%02X\n", status);
        }
        break;

        case ZigBeeTransmitStatus: {
            char id, address16[2], retry, delivery, discovery;
            scan(FrameID, &id);
            scan(Address16, address16, sizeof(address16));
            scan(RetryCount, &retry);
            scan(DeliveryStatus, &delivery);
            scan(DiscoveryStatus, &discovery);
            mon.printf("ZigBeeTransmitStatus, Id=%d, ad=%02X%02X, Rty=%d, Dlv=%02X, Dsc=%02X\n",
                       id & 255, address16[0], address16[1], retry & 255, delivery, discovery);
        }
        break;

        case ZigBeeReceivePacket: {
            char address64[8], address16[2], options, data[32];
            int length = 0;
            scan(Address64, address64, sizeof(address64));
            scan(Address16, address16, sizeof(address16));
            scan(ReceiveOptions, &options);
            scan(ReceivedData, data, sizeof(data), &length);
            mon.printf("ZigBeeReceivePacket, AD=%02X%02X%02X%02X %02X%02X%02X%02X, ad=%02X%02X, Op=%02X, Length=%d, ",
                       address64[0], address64[1], address64[2], address64[3], address64[4], address64[5],
                       address64[6], address64[7], address16[0], address16[1], options, length);
            dump(data, min(sizeof(data), length));
        }
        break;

        case ZigBeeIODataSampleRxIndicator: {
            char address64[8], address16[2], options, data[16];
            int length = 0;
            scan(Address64, address64, sizeof(address64));
            scan(Address16, address16, sizeof(address16));
            scan(ReceiveOptions, &options);
            scan(ReceivedData, data, sizeof(data), &length);
            mon.printf("ZigBeeIODataSampleRxIndicator, AD=%02X%02X%02X%02X %02X%02X%02X%02X, ad=%02X%02X, Op=%02X, ",
                       address64[0], address64[1], address64[2], address64[3], address64[4], address64[5],
                       address64[6], address64[7], address16[0], address16[1], options);
            dumpIOSample(data, length);
        }
        break;

        case RemoteCommandResponse: {
            char address64[8], address16[2], id, name[2], status, data[16];
            int length = 0;
            scan(Address64, address64, sizeof(address64));
            scan(Address16, address16, sizeof(address16));
            scan(FrameID, &id);
            scan(ATCommand, name, sizeof(name));
            scan(Status, &status);
            scan(CommandData, data, sizeof(data), &length);
            mon.printf("RemoteCommandResponse, AD=%02X%02X%02X%02X %02X%02X%02X%02X, ad=%02X%02X, Id=%d, Nm=%c%c, St=%02X, ",
                       address64[0], address64[1], address64[2], address64[3], address64[4], address64[5],
                       address64[6], address64[7], address16[0], address16[1], id & 255, name[0], name[1], status);
            if (name[0] == 'I' && name[1] == 'S' && status == 0)
                dumpIOSample(data, length);
            else
                dump(data, length);
        }
        break;

        default: {
            char data[32];
            int length = 0;
            scan(RawData, data, sizeof(data), &length);
            mon.printf("Frametype:%02X, Length=%d, Data=", buf[INDEX(out + 2)] & 255, length);
            dump(data, min(sizeof(data), length));
        }
    }
}

void XBee::dumpAll() {
    mon.printf("cur = %04X\n", cur);
    mon.printf("in = %04X\n", in);
    mon.printf("out = %04X\n", out);
    mon.printf("received = %04X\n", received);
    mon.printf("free = %d\n", free);
    for (int i = 0; i < BUFSIZE; i += 16) {
        mon.printf("%04X: ", i);
        dump(buf + i, 16);
    }
}

void XBee::dump(const char* data, int length) {
    for (int i = 0; i < length; i++) mon.printf("%02X", data[i]);
    mon.printf(" | ");
    for (int i = 0; i < length; i++) mon.printf("%c", isprint(data[i]) ? data[i] : '.');
    mon.printf("\n");
}

void XBee::dumpIOSample(const char* data, int length) {
    if (length > 0) {
        IOSample sample(data);
        //sample.print(mon);
        mon.printf(sample);
    }
}