#include "mbed.h"
#include <ctype.h>

int encodeFormUrl(char *s, char *t) {
    char *head = t;
    for (char c; (c = *s) != 0; s++)
        switch (c) {
            case '\r':
                break;
            case ' ' :
                *t++ = '+';
                break;
            default:
                t += sprintf(t, isalnum(c) ? "%c" : (c == '\n') ? "\r%c" : "%%%02X", c);
        }
    *t = '\0';
    return t - head;
}

void encodeBase64(char ibuf[], int length, char *obuf) {
    const char BASE64[] =
        "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    int i, j;
    for (i = j = 0; j < length; j += 3, i += 4) {
        long a = ibuf[j] << 16 |
                 (j + 1 < length ? ibuf[j + 1] << 8 : 0) |
                 (j + 2 < length ? ibuf[j + 2] : 0);
        for (int k = 3; k >= 0; k--, a >>= 6)
            obuf[i + k] = (j + k - 1) < length ? BASE64[a & 63] : '=';
    }
    obuf[i] = '\0';
}

void encodeBase64(char *ibuf, char *obuf) {
    encodeBase64(ibuf, strlen(ibuf), obuf);
}

void getValue(char *path, char *name, char *value) {
    FILE *fp = fopen(path, "r");
    if (!fp) return;

    char buf[512];
    int i = strlen(name);
    while (fgets(buf, 511, fp)) {
        if (strncmp(name, buf, i) == 0 && (buf[i] == ':' || isspace(buf[i]))) {
            while (buf[i] && buf[i] != ':') i++;
            if (buf[i]) i++;
            while (buf[i] && isspace(buf[i])) i++;
            for (int j = strlen(buf) - 1; isspace(buf[j]); j--) buf[j] = '\0';
            strcpy(value, &buf[i]);
            break;
        }
    }
    fclose(fp);
}