#include "EthernetNetIf.h"
#include "SimpleSocket.h"
#include "utils.h"

/*
Twitter client thru api.supertweet.net proxy server

In order to tweet thru api.supertweet, prepare a text file "tweet.txt" in
mbed local file system (flash), containing the following 3 lines:

user:<user account>
password:<password for supertweet.net>
message:<unicode text in UTF-8>

*/

int main() {
    EthernetNetIf eth;
    eth.setup();
      
    ClientSocket client("api.supertweet.net", 80);
    if (!client) error("connection failed\n");
    
    LocalFileSystem local("local");    
    char user[16], password[32], message[420];
            
    getValue("/local/tweet.txt", "user", user);
    getValue("/local/tweet.txt", "password", password);
    getValue("/local/tweet.txt", "message", message);

    char credential[48], credential2[64], message2[1260];
    sprintf(credential, "%s:%s", user, password);
    encodeBase64(credential, credential2);
    encodeFormUrl(message, message2);

    const char *request =
        "POST /1/statuses/update.xml HTTP/1.1\r\n"
        "Host: api.supertweet.net\r\n"
        "Authorization: Basic %s\r\n"
        "Content-Length: %d\r\n"
        "Content-Type: application/x-www-form-urlencoded\r\n"
        "\r\n"
        "status=";

    client.printf(request, credential2, strlen(message2) + 7);
    client.write(message2, strlen(message2));
    printf(request, credential2, strlen(message2) + 7);
    printf("%s", message2);
    printf("\n");

    while (client) {
        if (client.available()) {
            while (client.available()) {
                char response[128] = {};
                client.read(response, sizeof(response) - 1);
                printf("%s", response);
            }
            client.close();
        }
    }

    printf("\ndone\n");
}