/*
Copyright (c) 2011, Senio Networks, Inc.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef LOCATION_H
#define LOCATION_H

#include "Utils.h"

/**
 * Location info object
 */
class Location {
public:
    /**
     * Constructor
     *
     * @param longitude longitude in degrees
     * @param latitude latutude in degrees
     * @param elevation elevation in meters
     */
    Location(double longitude = 0, double latitude = 0, float elavation = 0)
            : longitude(longitude), latitude(latitude), elevation(elevation) {}

    /**
     * creates a Location object from a config file
     *
     * @param filename name of the config file
     * @param verbose if true display debug info
     */
    static Location create(char *filename, bool verbose = false) {
        double longitude = 0, latitude = 0;
        float elevation = 0;

        if (filename) {
            char path[32];
            LocalFileSystem local("local");
            sprintf(path, "/local/%s", filename);
            if (FILE *fp = fopen(path, "r")) {
                Utils::fgetValues(fp, "longitude:%lf", &longitude);
                Utils::fgetValues(fp, "latitude:%lf", &latitude);
                Utils::fgetValues(fp, "elevation:%f", &elevation);
                fclose(fp);
                if (verbose) {
                    printf( "longitude:%lf\n", longitude);
                    printf( "latitude:%lf\n", latitude);
                    printf( "elevation:%f\n", elevation);
                }
            }
        }

        return Location(longitude, latitude, elevation);
    }

    /**
     * Returns longitude
     *
     * @returns longitude in degrees
     */
    double getLongitude() {
        return longitude;
    }

    /**
     * Sets longitude
     *
     * @param longitude longitude in degrees
     */
    void setLongitude(double longitude) {
        this->longitude = longitude;
    }

    /**
     * Returns longitude
     *
     * @returns longitude in degrees
     */    double getLatitude() {
        return latitude;
    }

    /**
     * Sets latitude
     *
     * @param latitude latitude in degrees
     */
    void setLatitude(double latinude) {
        this->latitude = latitude;
    }

    /**
     * Returns elevation
     *
     * @returns elevation in meters
     */
    float getElevation() {
        return elevation;
    }

    /**
     * Sets elevation
     *
     * @param elevation elevation in meters
     */
    void setElavation(float elevation) {
        this->elevation = elevation;
    }

private:
    double longitude, latitude;
    float elevation;
};

#endif