/*
Copyright (c) 2011, Senio Networks, Inc.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef UTILS_H
#define UTILS_H

#include "mbed.h"
#include <ctype.h>
#include <stdarg.h>

/**
 * Utility functions
 */
class Utils {
public:
    /**
     * encodes string in percent encoding
     *
     * @param s source string
     * @param t encoded string
     */
    static int encodeFormUrl(char *s, char *t) {
        char *head = t;
        for (char c; (c = *s) != 0; s++)
            switch (c) {
                case '\r':
                    break;
                case ' ' :
                    *t++ = '+';
                    break;
                default:
                    t += sprintf(t, isalnum(c) ? "%c" : (c == '\n') ? "\r%c" : "%%%02X", c);
            }
        *t = '\0';
        return t - head;
    }

    /**
     * encodes data to BASE64 string
     *
     * @param ibuf input buffer
     * @param length length of the input data
     * @param obuf output buffer
     */
    static void encodeBase64(char ibuf[], int length, char *obuf) {
        const char BASE64[] =
            "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        int i, j;
        for (i = j = 0; j < length; j += 3, i += 4) {
            long a = ibuf[j] << 16 |
                     (j + 1 < length ? ibuf[j + 1] << 8 : 0) |
                     (j + 2 < length ? ibuf[j + 2] : 0);
            for (int k = 3; k >= 0; k--, a >>= 6)
                obuf[i + k] = (j + k - 1) < length ? BASE64[a & 63] : '=';
        }
        obuf[i] = '\0';
    }

    /**
     * encodes string to BASE64 string
     * @param ibuf input string buffer
     * @param obuf output buffer
     */
    static void encodeBase64(char *ibuf, char *obuf) {
        encodeBase64(ibuf, strlen(ibuf), obuf);
    }

    /**
     * gets values from a file according to the specified pattern format
     *
     * @param fp pointer to the input FILE
     * @param pattern scanf format string, followed by variables to store the retrieved data
     */
    static bool fgetValues(FILE *fp, const char *pattern, ...) {
        va_list argv;
        va_start(argv, pattern);

        rewind(fp);
        while (!feof(fp)) {
            char buf[128];
            fgets(buf, sizeof(buf) - 1, fp);
            int ret = vsscanf(buf, pattern, argv);
            if (ret > 0) {
                return true;
            }
        }
        return false;
    }
};
#endif