#include "EthernetNetIf.h"
#include "SimpleSocket.h"

void findbuddy() {
    EthernetNetIf eth;
    eth.setup();
   
    IpAddr myIP = eth.getIp();
    DatagramSocket datagram(myIP, 7777);

    Host buddy;
    for (int i = myIP[3] + 1;; i = (i - myIP[3] + 260) % 10 + myIP[3] + 1) {
        printf("sending message to %d.%d.%d.%d\n", myIP[0], myIP[1], myIP[2], i);
        datagram.printf("Hello World\n");
        datagram.send(IpAddr(myIP[0], myIP[1], myIP[2], i), 7777);
        // this will not reach target during the first round,
        // and in order to receive successfully,
        // timeout must be at least 4 seconds (default = 5.0 seconds)
        if (datagram.receive(&buddy, 4) > 0) {
            IpAddr ip = buddy.getIp();
            char buf[80] = {};
            int len = datagram.read(buf, sizeof(buf) - 1);
            printf("received from %d.%d.%d.%d: %s", ip[0],ip[1], ip[2], ip[3], buf);
            break;
        }
    }

    for (int i = 0; i < 2; i++) {
        datagram.printf("There you are!\n");
        datagram.send(buddy.getIp(), 7777);

        if (datagram.receive() > 0) {
            char buf[80] = {};
            int len = datagram.read(buf, sizeof(buf) - 1);
            printf("received: %s", buf);
        }
    }
}