#include "EthernetNetIf.h"
#include "SimpleSocket.h"

void multicast() {
    EthernetNetIf eth;
    eth.setup();
    
    Host multicast(IpAddr(239, 192, 1, 100), 50000);
    DatagramSocket datagram(multicast);
    
    while (true) {
        Host host;
        if (datagram.receive(&host, 1 + (rand() % 5) / 3.0) > 0) {
            int value;
            datagram.scanf("%d", &value);
            IpAddr ip = host.getIp();
            printf("received from %d.%d.%d.%d:%d %d\n", ip[0], ip[1], ip[2], ip[3], host.getPort(), value);
        } else {
            char* message = "12345!";
            datagram.printf(message);
            datagram.send(multicast);
            printf("sent: %s\n", message);
            wait(1);
        }
    }
}
